<?php 
    /**
    *
    * copyright (c) 2013-2025 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class VisualizzatoreComunicazioni extends VisualizzatoreComponente {
        private $stringaGruppiUtente;
        private $impostazioniRicerca;
        
        function generaContenuto($dati) {
            if($dati["tipo"]=="ticket" || $dati["tipo"]=="segnalazione") {
		$elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
		$cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    		
		$parametriRicerca  = $cerca!="" ? ["tipo"=>$dati["tipo"],"oggetto"=>$cerca] : array("tipo"=>$dati["tipo"]);
		$parametri = array("tabella"=>"geecAd_comunicazioni", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);    
		$ricerca = new Ricerca(parent::getDb(), $parametri, $this->impostazioniRicerca,"comunicazioni.php");
		if($dati["tipo"]=="ticket") { // se sta visualizzando i ticket ci vuole il filtro dell'utente
			$ricerca->setCondizionePrincipale("idUtente = {$_SESSION["geecomUser_id"]} AND ");
		}
	   	 ?>
                    <div class="col-lg-5">
                        <div class="card bg-light border-0 p-3">
                            <h5 class="mb-3">Crea <?= $dati["tipo"] ?></h5>
                            <div class="btn-group float-right d-lg-none" role="group" aria-label="Basic example">
                            	<button class="btn btn-light " data-toggle="collapse" href="#nuovoTicket"> <i class="fas fa-plus fa-xs"></i> </button>
                            </div>

                            <div id="nuovoTicket" class="collapse show in">
                                <form name="formCreaTicket" action="controller/controllerComunicazioni.php" method="POST" enctype="multipart/form-data">
                                    <input class="d-none" type="text" name="id" value="0">
                                    <input class="d-none" type="text" name="operazione" value="creaComunicazioneUtente">
                                    <input class="d-none" type="text" name="tipo" value="<?= $dati["tipo"] ?>">
                                    
                                    <div class="form-group">
                                        <input type="text" class="form-control" id="oggetto" name="oggetto" placeholder="Oggetto">
                                    </div>

                                    <div class="form-group">
                                        <select class="form-control" name="priorita" id="exampleFormControlSelect1">
                                            <option value="bassa">Priorità Bassa</option>
                                            <option value="media">Priorità Media</option>
                                            <option value="alta">Priorità Alta</option>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group">
                                        <textarea class="form-control tiny" id="testo" rows="5" name="testo" placeholder="Scrivi qui il tuo ticket"></textarea>
                                    </div>
                                    
                                    <div class="form-group">
					    <div class="custom-file">
					    	<input type="file" name="file" class="custom-file-input" id="inputGroupFile04" aria-describedby="aggiungi allegato 1" accept="image/*,application/pdf">
					    	<label class="custom-file-label" for="inputGroupFile04">Scegli un file</label>
					    </div>
                                    </div>
                                    
                                    <div id="allegato2" class="d-none">
					    <div class="custom-file">
					    	<input type="file" name="file2" class="custom-file-input" id="inputGroupFile04" aria-describedby="aggiungi allegato 2" accept="image/*,application/pdf">
					    	<label class="custom-file-label" for="inputGroupFile04">Scegli un file</label>
					    </div>
                                    </div>
                                    
                                    <div id="allegato3" class="d-none">
					    <div class="custom-file">
					    	<input type="file" name="file3" class="custom-file-input" id="inputGroupFile04" aria-describedby="aggiungi allegato 3" accept="image/*,application/pdf">
					    	<label class="custom-file-label" for="inputGroupFile04">Scegli un file</label>
					    </div>
                                    </div>
                                    
                                    <div id="allegato4" class="d-none">
					    <div class="custom-file">
					    	<input type="file" name="file4" class="custom-file-input" id="inputGroupFile04" aria-describedby="aggiungi allegato 4" accept="image/*,application/pdf">
					    	<label class="custom-file-label" for="inputGroupFile04">Scegli un file</label>
					    </div>
                                    </div>
                                    
                                    <div id="allegato5" class="d-none">
					    <div class="custom-file">
					    	<input type="file" name="file5" class="custom-file-input" id="inputGroupFile04" aria-describedby="aggiungi allegato 5" accept="image/*,application/pdf">
					    	<label class="custom-file-label" for="inputGroupFile04">Scegli un file</label>
					    </div>
                                    </div>
                                    
                                    <div class="text-right">
                                        <button type="button" id="pulsanteAggiungiAllegato" class="btn btn-outline-primary" onclick="aggiungiAllegato()">Aggiungi allegato</button>
                                        <button type="button" id="pulsanteCreaTicket" class="btn btn-primary invia" onclick="inviaNuovoTicket()">Invia</button>
                                    </div>
                                </form>
                            </div>	
                        </div>
                    </div>
                    <div class="col-lg-7">
			    <div class="d-sm-flex justify-content-between mb-3">
				    <?php
					$ricerca->stampaSelectNumeroElementi($cerca,["tipo"=>$dati["tipo"]]);
					$ricerca->stampaFormRicerca($cerca,["tipo"=>$dati["tipo"]]);
				    ?>
			    </div>
			    <div class="table-responsive table-sm">
				    <?php

					if(isset($_GET["pag"])) {
					    $ris = $ricerca->eseguiRicerca($_GET["pag"]);
					}
					else {
					    $ris = $ricerca->eseguiRicerca(1);
					}

					if($dati["tipo"]=="ticket") {
						$colonne = array("ID","Oggetto","Creato il","Stato","");
					}
					else {
						$colonne = array("ID","Autore","Oggetto","Creato il","Stato","");
					}
					$tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
					$tabella->setTipo("normale");
					while($ticket = $ris->fetch_assoc()) {
					    $dataCreazione = date("d/m/Y",strtotime($ticket["dataCreazione"]));
					    if($dati["tipo"]=="ticket") {
					    	$tabella->aggiungiNuovaRiga(array($ticket["id"],"<b><a href=\"dettagliTicket.php?id={$ticket["id"]}\">{$ticket["oggetto"]}</a></b>",$dataCreazione,$ticket["stato"]),[]);	    					
					    }
					    else {
					    	$datiUtente = $this->getDb()->leggiSingolaRiga("geec_utenti",$ticket["idUtente"]);
					    	$tabella->aggiungiNuovaRiga(array($ticket["id"],$datiUtente["nome"]." ".$datiUtente["cognome"],"<b><a href=\"dettagliTicket.php?id={$ticket["id"]}\">{$ticket["oggetto"]}</a></b>",$dataCreazione,$ticket["stato"]),[]);
					    }
					}

					$tabella->stampa("pagina",0);
					    
					$ricerca->stampaPaginazione(true,"gestionePagine.php");
				    ?>
			    </div>
                    </div>
	   	 <?php
            }
            else if($dati["tipo"]=="comunicazione") {
                $this->stringaGruppiUtente = " AND c.id IN ( SELECT idComunicazione FROM geecAd_gruppiDestinatari WHERE idGruppoDestinatario = 0 ";
                foreach($_SESSION["geecomUser_gruppiUtente"] as $gruppo) {
                    $this->stringaGruppiUtente .= "OR idGruppoDestinatario = $gruppo ";
                }
                $this->stringaGruppiUtente .= ")";
                
                $queryNumeroArticoli = "SELECT COUNT(*) FROM geecAd_comunicazioni AS c WHERE tipo LIKE '{$dati["tipo"]}' {$this->stringaGruppiUtente}";
		$risNumArticoli = parent::getDb()->eseguiQueryLettura($queryNumeroArticoli);
		$numArticoli = $risNumArticoli->fetch_array(MYSQLI_NUM);

		if($dati["tipo"]=="ticket") {
			$queryComunicazioni = "SELECT * FROM geecAd_comunicazioni WHERE tipo LIKE '{$dati["tipo"]}' AND idUtente={$_SESSION["geecomUser_id"]} ORDER BY id DESC";
		}
		else if($dati["tipo"]=="comunicazione") {
			$queryComunicazioni = "SELECT * FROM geecAd_comunicazioni AS c WHERE tipo LIKE '{$dati["tipo"]}' {$this->stringaGruppiUtente}";
		}
		else {
			$queryComunicazioni = "SELECT * FROM geecAd_comunicazioni WHERE tipo LIKE '{$dati["tipo"]}'";
		}
		$risComunicazioni = parent::getDb()->eseguiQueryLettura($queryComunicazioni);

		if($risComunicazioni->num_rows==0) {
			if($dati["tipo"]=="segnalazione") {
			    $tipoComunicazione = "segnalazioni";
			}
			else if($dati["tipo"]=="comunicazione") {
			    $tipoComunicazione = "comunicazioni";
			}
			else {
			    $tipoComunicazione = $dati["tipo"];
			}
			echo("<h3>Non ci sono {$tipoComunicazione} al momento</h3>");
		}
	?>
		<div class="col-12">
		<?php
			while($comunicazione = $risComunicazioni->fetch_assoc()) {
			    $this->stampaComunicazione($comunicazione);
			}
		?>
		</div>
	<?php
            }
        }
                
        function stampaComunicazione($comunicazione) {
            $data = date("d/m/Y",strtotime($comunicazione["dataCreazione"]));
            echo "<div class=\"card\">
                <div class=\"card-header\">
                    <h5 class=\"mb-1\">{$comunicazione["oggetto"]}</h5>
                </div>
                <div class=\"card-body\">
                    <i class=\"far fa-calendar-alt mr-2 d-inline-block\"></i><h6 class=\"text-muted d-inline-block\">$data</h6>
                    {$comunicazione["testo"]}
                </div>
            </div>";
        }
        
        function getImpostazioniRicerca() {
        	return $this->impostazioniRicerca;
        }
        
        function setImpostazioniRicerca($impostazioniRicerca) {
        	$this->impostazioniRicerca = $impostazioniRicerca;
        }
    }
